﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Printing;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using System.Management;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.BAL;

namespace AZVIC.Ei8htPOS.POSRetail.Helper
{
    public static class BarcodePrintHelper
    {
        public static void PrintBarcode(List<Products> Data, int NumberOfCopies = 1)
        {
            foreach (Products product in Data)
            {
                for (int copy = 0; copy < NumberOfCopies; copy++)
                {
                    //Window win = new Window() { Height = 130, Width = 200 };
                    Canvas PrintCanvas = new Canvas();

                    #region Encode the Data
                    /////////////////////////////////////
                    // Encode The Data
                    /////////////////////////////////////
                    BarcodeHelper bb = new BarcodeHelper();
                    bb.BarcodeType = BarcodeHelper.BarcodeEnum.Code39;
                    bb.Data = product.ProductCode;
                    bb.CheckDigit = BarcodeHelper.YesNoEnum.Yes;
                    bb.encode();

                    int thinWidth;
                    int thickWidth;

                    thinWidth = 1;
                    thickWidth = 2 * thinWidth;

                    string outputString = bb.EncodedData;
                    string humanText = bb.HumanText;
                    #endregion

                    #region Draw the Barcode
                    /////////////////////////////////////
                    // Draw The Barcode
                    /////////////////////////////////////
                    int len = outputString.Length;
                    int currentPos = 26;
                    int currentTop = 10;
                    int currentColor = 0;
                    for (int i = 0; i < len; i++)
                    {
                        Rectangle rect = new Rectangle();
                        rect.Height = 25;
                        if (currentColor == 0)
                        {
                            currentColor = 1;
                            rect.Fill = new SolidColorBrush(Colors.Black);
                        }
                        else
                        {
                            currentColor = 0;
                            rect.Fill = new SolidColorBrush(Colors.White);
                        }
                        Canvas.SetLeft(rect, currentPos);
                        Canvas.SetTop(rect, currentTop);

                        if (outputString[i] == 't')
                        {
                            rect.Width = thinWidth;
                            currentPos += thinWidth;
                        }
                        else if (outputString[i] == 'w')
                        {
                            rect.Width = thickWidth;
                            currentPos += thickWidth;
                        }
                        PrintCanvas.Children.Add(rect);
                    }
                    #endregion

                    #region Add Human Readable Text
                    /////////////////////////////////////
                    // Add the Human Readable Text
                    /////////////////////////////////////
                    //TextBlock tb = new TextBlock();
                    //tb.Text = humanText;
                    //tb.FontSize = 15;
                    //tb.FontFamily = new FontFamily("Courier New");
                    //Rect rx = new Rect(0, 0, 0, 0);
                    //tb.Arrange(rx);
                    //Canvas.SetLeft(tb, 50);//(currentPos - tb.ActualWidth) / 2);
                    //Canvas.SetTop(tb, currentTop + 25);
                    //PrintCanvas.Children.Add(tb);

                    //TextBlock tbProductName = new TextBlock();
                    //tbProductName.Text = product.ProductName;
                    //tbProductName.FontSize = 15;
                    //tbProductName.FontFamily = new FontFamily("Courier New");
                    //Rect rxProductName = new Rect(0, 0, 0, 0);
                    //tbProductName.Arrange(rxProductName);

                    //Canvas.SetLeft(tbProductName, 27);//(currentPos - tbProductName.ActualWidth) / 2);
                    //Canvas.SetTop(tbProductName, currentTop + 40);
                    //PrintCanvas.Children.Add(tbProductName);

                    //TextBlock tbColor = new TextBlock();
                    //tbColor.Text = ProductColorBL.GetItem(product.ProductColorID, string.Empty).ColorName;
                    //tbColor.FontSize = 15;
                    //tbColor.FontFamily = new FontFamily("Courier New");
                    //Rect rxColor = new Rect(0, 0, 0, 0);
                    //tbColor.Arrange(rxProductName);
                    //Canvas.SetLeft(tbColor, 27);//(currentPos - tbColor.ActualWidth) / 2);
                    //Canvas.SetTop(tbColor, currentTop + 55);
                    //PrintCanvas.Children.Add(tbColor);

                    //TextBlock tbSize = new TextBlock();
                    //tbSize.Text = ProductMeasurementBL.GetItem(product.ProductMeasurementID, string.Empty).MeasurementName;
                    //tbSize.FontSize = 15;
                    //tbSize.FontFamily = new FontFamily("Courier New");
                    //Rect rxSize = new Rect(0, 0, 0, 0);
                    //tbSize.Arrange(rxSize);
                    //Canvas.SetLeft(tbSize, 27);//(currentPos - tbSize.ActualWidth) / 2);
                    //Canvas.SetTop(tbSize, currentTop + 70);
                    //PrintCanvas.Children.Add(tbSize);

                    #endregion

                    //win.Content = PrintCanvas;

                    System.Drawing.Printing.PrinterSettings settings = new System.Drawing.Printing.PrinterSettings();
                    string defaultPrinter = settings.PrinterName;

                    while (AppSession.CheckPrinterAssigned())
                    {
                        //ChangeDefaultPrinter(Properties.Settings.Default.BarCodePrinter);

                        PrintDialog pd = new PrintDialog();

                        if (Properties.Settings.Default.InvoicePrinter.Contains(@"\\"))
                        {
                            EnumeratedPrintQueueTypes[] enumerationFlags = { EnumeratedPrintQueueTypes.Connections, EnumeratedPrintQueueTypes.Local, EnumeratedPrintQueueTypes.Shared, EnumeratedPrintQueueTypes.TerminalServer };
                            LocalPrintServer printServer = new LocalPrintServer();
                            PrintQueueCollection printQueuesOnLocalServer = printServer.GetPrintQueues(enumerationFlags);
                            pd.PrintQueue = printQueuesOnLocalServer.Where(x => x.FullName == Properties.Settings.Default.InvoicePrinter).FirstOrDefault();
                        }
                        else
                        {
                            pd.PrintQueue = new LocalPrintServer().GetPrintQueue(Properties.Settings.Default.InvoicePrinter);
                        }

                        PrintTicket pt = pd.PrintQueue.DefaultPrintTicket;
                        pt.PageMediaSize = new PageMediaSize(190, 100);
                        pd.PrintTicket = pt;
                        pd.PrintVisual(PrintCanvas, "Printing Barcode");

                        //ChangeDefaultPrinter(Properties.Settings.Default.InvoicePrinter);
                        break;
                    }
                }
            }

        }

        public static void ChangeDefaultPrinter(string printerName)
        {
            var query = new ManagementObjectSearcher("SELECT * FROM Win32_Printer"); var printers = query.Get();
            foreach (ManagementObject printer in printers)
            {
                if (printer["name"].ToString().Trim().ToLower().Contains(printerName.ToLower()))
                {
                    printer.InvokeMethod("SetDefaultPrinter", new object[] { printerName });
                    break;
                }
            }

        }
    }

}
